<?php
class gift
{
	private $db;
	private $gift_table;
	private $type_table;
	private $order_table;

	function __construct()
	{
		global $db;
		$this->db=$db;
		$this->gift_table=LA_PRE.'gift';
		$this->type_table=LA_PRE.'gift_type';
		$this->order_table=LA_PRE.'gift_order';
	}

	function giftlist($endtime='',$k='',$status)
	{
		global $page,$_siteid,$siteidobj;
		$userid=intval($userid);
		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		$where.=$endtime?' AND updatetime<=\''.(trim($endtime)+24*3600).'\'':'';
		if($status==-1)
		{
			$where.='';
		}
		elseif($status==0)
		{
			$where.=' AND expire<'.TIME;
		}
		else
		{
			$where.=' AND expire>='.TIME;
		}
		$where.=$k?' AND title LIKE \'%'.$k.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='expire DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=15;
		$result=$datalist->getlist($this->gift_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function formatgifturl($id,$is_rewrite=1,$preview=0)
	{	
		global $moduleobj,$configobj,$urlcacheobj;
		
		$id=intval($id);

		$key='key-gift-'.$id;
		$url=$urlcacheobj->get($key);
		
		if(!$url)
		{
			$modinfo=$moduleobj->get(30);
			$modsettings=$configobj->getconfig($_SESSION['siteid'],30);
			
			if(preg_match('/http:\/\/(.+)/i',$modsettings['domain']))
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= $modsettings['domain'].'gift-'.intval($id).'.html';
				}
				else
				{
					$url= $modsettings['domain'].'index.php?mod='.$modinfo['folder'].'&action=show&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			else
			{
				if($modsettings['is_rewrite'] && $is_rewrite)
				{
					$url= LA_PATH.$modinfo['folder'].'/gift-'.intval($id).'.html';
				}
				else
				{
					$url= LA_PATH.$modinfo['folder'].'/index.php?mod='.$modinfo['folder'].'&action=show&id='.intval($id).($preview?'&preview=1':'');
				}
			}
			$urlcacheobj->set($key,$url);
		}

		return $url;
		
	}

	function getgift($id)
	{	
		$id=intval($id);
		return $this->db->fetch_one("SELECT * FROM `$this->gift_table` WHERE `$this->gift_table`.`id`=$id");
	}

	function giftstatis($moduleid=30,$status=-1,$typeid=0)
	{
		global $siteidobj,$_siteid;
		$moduleid=intval($moduleid);
		$status=intval($status);
		$typeid=intval($typeid);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		if($status==-1)
		{
			$where.='';
		}
		elseif($status==0)
		{
			$where.=' AND expire<'.TIME;
		}
		else
		{
			$where.=' AND expire>='.TIME;
		}
		
		$where.=$moduleid?' AND moduleid='.$moduleid:'';
		$where.=$typeid?' AND typeid='.$typeid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->gift_table` WHERE $where");
	}

	function giftorderstatis($gid)
	{
		global $siteidobj,$_siteid;
		$gid=intval($gid);

		$where=$_siteid?' siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':'1';
		
		$where.=$gid?' AND giftid='.$gid:'';

		return get_cache_counts("SELECT COUNT(*) AS count FROM `$this->order_table` WHERE $where");
	}

	function giftset($info,$ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getgift($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->gift_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->update($this->gift_table,$info,'id='.$id);
					$this->db->update($hash_table,$info,'mid='.$id);
				}
			}
		}
		return true;
	}

	function gift_delete($ids=array())
	{
		global $settings,$_siteid,$siteidobj,$modelobj;

		$ids=is_array($ids)?array_map('intval',$ids):array(intval($ids));
		foreach($ids as $id)
		{
			if($id)
			{
				$cinfo=$this->getgift($id);
				if(!$cinfo || ($_siteid && !in_array($cinfo['siteid'],$siteidobj->getchildid($_siteid))))
				{
					return false;
				}
				else
				{
					$hash_table=get_hash_table($this->gift_table.'_data',$id,$modelobj->subformcount2($cinfo['modelid']));
					$this->db->mysql_delete($this->gift_table,$id);
					$this->db->mysql_delete($hash_table,$id,'mid');
				}
			}
		}
		return true;
	}

	function gift_settop($id,$userid,$moduleid)
	{
		global $settings,$_gradeid,$_point,$_amount,$memberobj;
		$id=intval($id);
		$userid=intval($userid);
		$moduleid=intval($moduleid);

		$tiao=$settings['top_type']==0?$_point:$_amount;
		if($settings['top_fee']<=$tiao)
		{
			if($settings['top_type']==0)
			{
				$memberobj->set($userid,array('point'=>max(0,$_point-$settings['top_fee'])));
			}
			else
			{
				$memberobj->set($userid,array('amount'=>max(0,$_amount-$settings['top_fee'])));
			}
			return $this->db->query("UPDATE `$this->gift_table` SET `$this->gift_table`.`istop`='".(TIME+24*3600)."' WHERE `$this->gift_table`.`id`=$id AND  `$this->gift_table`.`userid`=$userid");
		}
		
		return false;
	}

	function admin_gift_add($info,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj,$memberobj;
		$info['modelid']=intval($modelid);
		$modelinfo=$modelobj->info($modelid);
	
		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);

		$info['updatetime']=TIME;
		$info['siteid']=intval($_SESSION['siteid']);
		$info['mid']=$this->db->insert(LA_PRE.$modelinfo['tbname'],$info,true);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$info['mid'],$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->insert($hash_table,$info,true);
	}

	function admin_gift_edit($info,$id,$modelid=0,$extend=0)
	{
		global $modelobj,$settings,$dataobj,$cacheobj;
		$modelid=intval($modelid);
		$extend=intval($extend);
		$id=intval($id);
		
		$modelinfo=$modelobj->info($modelid);

		$dataobj->setmodel(array(intval($modelid),intval($extend)));
		$info=$dataobj->filter($info);
		$info['updatetime']=TIME;

		$info['siteid']=intval($_SESSION['siteid']);
		$this->db->update($this->gift_table,$info,'id='.$id);
		$hash_table=get_hash_table(LA_PRE.$modelinfo['tbname'].'_data',$id,$modelobj->subformcount(intval($extend)));
		$cacheobj->clear();
		return $this->db->update($hash_table,$info,'mid='.$id);
	}
	
	function typelist($moduleid=0)
	{
		global $page,$_siteid,$siteidobj;
		$moduleid=intval($moduleid);
		$typeid=intval($typeid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$moduleid?' AND moduleid='.$moduleid:'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='id ASC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->type_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function optype($name,$newname,$ids)
	{
		$newdata=array();
		$this->db->query("TRUNCATE TABLE `$this->type_table`");
		if($ids)foreach($ids as $id)
		{
			if($name[$id])
			{
				$newdata['id']=$id;
				$newdata['name']=$name[$id];
				$newdata['moduleid']=30;
				$this->db->insert($this->type_table,$newdata,true);
			}
		}
		$newdata=array();
		if($newname)foreach($newname as $key => $val)
		{
			if($newname[$key])
			{
				$newdata['name']=$val;
				$newdata['moduleid']=30;
				$this->db->insert($this->type_table,$newdata);
			}
		}

		return true;
	}

	function typeinfo($id)
	{
		return $this->db->fetch_one("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`id`=".intval($id));
	}

	function typename($id)
	{
		$r=$this->typeinfo($id);
		return $r['name'];
	}

	function type_select($moduleid=30)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`id` ASC");

		foreach($r as $_r)
		{
			$str.='<option value="'.$_r['id'].'">'.$_r['name'].'</option>';
		}

		return $str;
	}

	function type_select_cat($moduleid=30,$parentid=0)
	{
		$str='';
		$r=$this->db->fetch_all("SELECT * FROM `$this->type_table` WHERE `$this->type_table`.`moduleid`=".intval($moduleid)." ORDER BY `$this->type_table`.`id` ASC");
		foreach($r as $_r)
		{
			$str.='<option value="'.$_r['typeid'].'">'.$_r['name'].'</option>';
		}

		return $str;
	}

	function orderlist($status,$starttime,$endtime,$sn,$giftid,$userid=0)
	{
		global $page,$_siteid,$siteidobj;
		$status=intval($status);
		$giftid=intval($giftid);
		$userid=intval($userid);

		$where=$_siteid?'siteid IN('.implode(',',$siteidobj->getchildid($_siteid)).')':1;
		$where.=$giftid?' AND giftid='.$giftid:'';
		$where.=$userid?' AND userid='.$userid:'';
		$where.=$starttime?' AND exchangedate>=\''.trim($starttime).'\'':'';
		$where.=$endtime?' AND exchangedate<=\''.(trim($endtime)+24*3600).'\'':'';
		$where.=$status>-1?' AND status='.$status:'';
		$where.=$k?' AND sn LIKE \'%'.$sn.'%\'':'';

		include SYSTEM_ROOT.'include/datalist.class.php';
		$datalist = new datalist();
		$orderby='status ASC,exchangedate DESC';
		$page=max(isset($page)?intval($page):1,1);
		$pagesize=25;
		$result=$datalist->getlist($this->order_table,$where,$orderby,$page,$pagesize);
		$this->pagestring=$datalist->pagestring;
		return $result;
	}

	function orderset($info,$sns=array())
	{
		$sns=is_array($sns)?array_map('trim',$sns):array(trim($sns));
		foreach($sns as $sn)
		{
			$sn=preg_replace('/[^0-9]/','',$sn);
			if($sn)
			{
				$this->db->update($this->order_table,$info,'sn=\''.$sn.'\'');
			}
		}
		return true;
	}

	function orderdelete($sns=array())
	{
		$sns=is_array($sns)?array_map('trim',$sns):array(trim($sns));
		foreach($sns as $sn)
		{
			$sn=preg_replace('/[^0-9]/','',$sn);
			if($sn)
			{
				$re=$this->db->query("DELETE FROM `$this->order_table` WHERE `$this->order_table`.`sn`='$sn'",true);
			}
		}
		return true;
	}
}
?>